	package gov.va.med.mhv.phr.chemlabs.decorator;

	import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.phr.decorator.DecoratorUtils;
import gov.va.med.mhv.phr.transfer.ChemLabsTestLab;
import gov.va.med.mhv.phr.transfer.ImpreciseDateComposite;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

import org.apache.commons.lang.StringEscapeUtils;
import org.tigris.atlas.messages.Message;
import org.tigris.atlas.messages.MessageFactory;
import org.tigris.atlas.messages.Messages;


	public class ChemLabsTestLabDecorator implements Serializable {

	    private static final long serialVersionUID = -8069372160082275849L;

	    private final ChemLabsTestLab testLab;
	    private Messages messages;
	    
	    protected static final String UNKNOWN = 
	        StringEscapeUtils.escapeHtml("Unknown");
	    protected static final String BLANK = StringEscapeUtils.escapeHtml("");    

	    
	    @SuppressWarnings("unchecked")
	    public ChemLabsTestLabDecorator(ChemLabsTestLab testLab) {
	        Precondition.assertNotNull("testLab", testLab);
	        this.testLab = testLab;
	    }   

		public String getSpecimen() {
			if(testLab!=null){
				String specimen = testLab.getSpecimenSource();
				return DecoratorUtils.escapedValueOrUnknown(specimen);
			}else{
				return UNKNOWN;
			}
	    }
		
		/*
		public String getOrderedTest() {
			if(testLab!=null && null != testLab.getOrderedTest()){
				return testLab.getOrderedTest().trim();
			}else{
				return UNKNOWN;
			}	
		}
		*/
	    
	    public Long getId() {
	    	return testLab.getId();
	    }

	    
	    public String getCollectedOn() {
	    	if(testLab!=null){
		    	ImpreciseDateComposite collectedOn = testLab.
		            getCollectedOnComposite();
		        if (collectedOn == null) {
		            return UNKNOWN;
		        } else{
		        	return collectedOn.getImpreciseValue();
		        }
	    	}
	        else{
	    		return "";
	    	}        
	    }    

	    public String getOrderingProvider() {
			if(testLab!=null){    	
				return DecoratorUtils.escapedValueOrUnknown(testLab.getOrderingProvider());
			}else{
				return UNKNOWN;
			}
	    }
	    
	 
	    public String getComments() {
	    	if(testLab!=null){
	    		return DecoratorUtils.escapedValueOrBlank(testLab.getComments());
	    	}else{
	    		return BLANK;
	    	}
	    }    
	    
	    public String getOrderingLocation() {
	    	if(testLab!=null){
	    		return DecoratorUtils.escapedValueOrUnknown(testLab.getOrderingLocation());
	    	}else{
	    		return UNKNOWN;
	    	}
	    }
	    
		public String getDetails() {
			if(testLab!=null){
				return "Details";
			}else{
				return "";
			}	
		}    

	    public Messages getMessages() {
	        return messages;
	    }

	    public void clearMessages() {
	    	messages = MessageFactory.createMessages();
	    }
	    
	    public void clearMessages(String key) {
	    	Messages newMessages = MessageFactory.createMessages();
	    	Collection msgs = new ArrayList();
	    	msgs.addAll(this.messages.getErrorMessages());
	    	msgs.addAll(this.messages.getInformationalMessages());
	    	for(Object o : msgs) {
	    		Message m = (Message)o;
	    		if ( ! m.getKey().equals(key)) {
	    			newMessages.addMessage(m);
	    		}
	    	}
	    	this.messages = newMessages;
	    }
	}
